/* Wiktor Zychla, 2003 */
using System;
using System.Drawing;
using System.Windows.Forms;

namespace WinForms_Dodatki
{
  public class C_XMainMenu : System.Windows.Forms.MainMenu 
  {
    private void topMenu_DrawItem(object sender, 
                                  System.Windows.Forms.DrawItemEventArgs e)
    {
      Rectangle mRect  = 
        new Rectangle(e.Bounds.X, e.Bounds.Y, e.Bounds.Width, e.Bounds.Height);
      Rectangle mRect2 = 
        new Rectangle(e.Bounds.X, e.Bounds.Y, e.Bounds.Width+1, e.Bounds.Height+1);

      if ( (e.State & DrawItemState.Selected) != 0 )  
      {
        e.Graphics.FillRectangle( new SolidBrush( SystemColors.Control ), mRect );
        e.Graphics.DrawRectangle( 
          new Pen( new SolidBrush( SystemColors.ControlDark ), 1 ), mRect );
      }
      else
      if ( (e.State & DrawItemState.HotLight) != 0 ) 
      {
        e.Graphics.FillRectangle( new SolidBrush( SystemColors.ControlLightLight ), mRect );
        e.Graphics.DrawRectangle( 
          new Pen( new SolidBrush( SystemColors.ControlDark ), 1 ), mRect );
      }
      else
      {
        e.Graphics.FillRectangle( new SolidBrush(SystemColors.Control), mRect2 );
      }
						
      MenuItem     mItem   = (MenuItem)sender;
      Font         mFont   = new Font( "MS Sans Serif", 10 );
      StringFormat sFormat = new StringFormat();
			
      sFormat.Alignment     = StringAlignment.Center;
      sFormat.LineAlignment = StringAlignment.Center;

      e.Graphics.DrawString(mItem.Text, mFont, new SolidBrush(Color.Black), mRect, sFormat );

      mFont.Dispose();
    }

    private void topMenu_MeasureItem(object sender, 
                            System.Windows.Forms.MeasureItemEventArgs e)
    {
      MenuItem     mItem = (MenuItem)sender;
      Font         mFont = new Font( "MS Sans Serif", 10 );

      SizeF sizeF  = e.Graphics.MeasureString( mItem.Text, mFont );
      e.ItemWidth  = (int)sizeF.Width;

      mFont.Dispose();
    }

    public C_XMainMenu( Menu mMenu ) 
    {
      foreach ( MenuItem mItem in mMenu.MenuItems )
      {				
        MenuItem newMenuItem = mItem.CloneMenu();
				
        ApplyMenuProperties ( newMenuItem );
        this.MenuItems.Add ( newMenuItem );
      }			
    }
		
    private void ApplyMenuProperties( MenuItem mItem )
    {
      if ( IsTopMenu( mItem ) )
      {
        mItem.OwnerDraw = true;
        mItem.DrawItem += 
	  new System.Windows.Forms.DrawItemEventHandler(this.topMenu_DrawItem);
        mItem.MeasureItem += 
	  new System.Windows.Forms.MeasureItemEventHandler(this.topMenu_MeasureItem);				
      }

      foreach ( MenuItem subMenu in mItem.MenuItems )
        ApplyMenuProperties( subMenu );
    }

    private static bool IsTopMenu( MenuItem mItem )
    {
      if ( mItem.Parent == null ) return true;
      return mItem.Parent == mItem.GetMainMenu();
    }
  }
}
